//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.0

import wesual.Controls 1.0

PopupAnchorItem {
    id : popup

    property Item colorBox
    property var items : []
    property int activeIndex : -1

    signal accepted(int result)

    anchors.centerIn : parent
    enabled : visible

    popup : Item {
        id : popupItem

        width : contentWrapper.width
        height : contentWrapper.height

        anchors {
            top : popup.popupVisible ? parent.bottom : undefined
            left : popup.popupVisible ? parent.left : undefined
            leftMargin : -popup.parent.width / 2
            topMargin : popup.parent.height / 2 - 1
        }

        opacity : 0

        states : [
            State {
                name : "visible"
                when : popup.popupVisible

                PropertyChanges {
                    target : popupItem
                    opacity : 1
                }
            }
        ]

        transitions : Transition {
            NumberAnimation {
                property : "opacity"
                duration : 200
            }
        }

        Rectangle {
            id : contentWrapper

            border {
                color : UI.color(UI.PrimaryControlBorder)
                width : 1
            }
            implicitWidth  : itemGrid.width + 4
            implicitHeight : itemGrid.height + 4

            Grid {
                id : itemGrid

                anchors.centerIn : parent

                width : childrenRect.width
                height : childrenRect.height

                property int itemSize : 24
                property int implicitItemWidth : itemSize + itemGrid.spacing

                columns : {
                    var totalItemsLength =
                            popup.items.length*itemGrid.implicitItemWidth;
                    // 10... 5+5 left/right row margin
                    if((totalItemsLength + 10) > colorBox.maxPopUpWidth) {
                        var rowCount = Math.floor((totalItemsLength
                                                / colorBox.maxPopUpWidth)  + 1);
                        if((totalItemsLength+rowCount*10)/rowCount <
                            colorBox.maxPopUpWidth*rowCount && rowCount > 2) {
                            return Math.floor((popup.items.length/rowCount) + 1);
                        }

                        return Math.floor(popup.items.length/rowCount);
                    }

                    return Math.floor((colorBox.maxPopUpWidth - 10) /
                                                            popup.items.length);
                }
                spacing : 1

                function isColorWhitish(colorvalue){
                    if(colorvalue === "white")
                        colorvalue = "#FFFFFF";

                    var intValue = parseInt(
                                colorvalue.substring(1,colorvalue.length), 16);
                    var white = 16777215;

                    if ( (white - intValue)  < 65793){ // Integer treshhold
                       return UI.color(UI.SecondaryControlBorder);
                    } else {
                       return colorvalue;
                    }
                }

                Repeater {
                    model : popup.items
                    delegate : Item {
                        id : delegateItem

                        readonly property int itemIndex : index
                        readonly property bool active :
                                                    popup.activeIndex === index

                        width : itemGrid.itemSize
                        height : itemGrid.itemSize

                        Rectangle {
                            id : itemBackground
                            height : itemGrid.itemSize
                            width : height
                            color : active ? itemGrid.isColorWhitish(modelData)
                                           : "white"
                            Behavior on color {
                                ColorAnimation { duration : 0 }
                            }
                        }

                        Rectangle {
                            id : colorInner
                            anchors.centerIn : itemBackground
                            width : 20
                            height : width
                            color : modelData
                        }
                        MouseArea {
                            anchors.fill : parent
                            acceptedButtons : Qt.LeftButton
                            hoverEnabled : true
                            onEntered : popup.activeIndex = index;
                            onReleased : popup.accepted(activeIndex)
                        }
                    } // colorbox item
                } // Repeater
            } // dropwdown column
        } // contentWrapper
    } // popupItem
}
